import sys
sys.path = ['C:/Users/Administrator/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path

from suds.client import Client
import datetime
from pytz import timezone
from pytz import common_timezones
import pytz
import time
from ReplaceDatabase import ReplaceDatabase
from time import sleep

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'GEORGIA'
state_short = 'GA'
domain = 'GA.VA.GOV'
facility1_site_id = '556'
facility2_abbr = 'GVARMC'
facility3_abbr = 'GVAOPC'

PatientSSN = '100000000'
patientLName = 'ROBERSON'
PatientFullName='ROBERSON,RAMIRO'
SeactionName = 'PRIMARY CARE'
AppointmentTypeCat = 'REGULAR'
ProviderResource = 'case1 step 9 test'

patientLName1 = 'BURGESS'
PatientFullName1 = 'BURGESS,LONNIE'
PatientSSN1 = '100000001'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase7Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase7/cache.dat")
sleep(60)

#print 'setp 2 Select Patient, Create Appointment, select Appointment'
PatientName = client.service.SearchPatients(facility1_site_id,PatientSSN)
#print PatientName

for p in PatientName.PatientSearchResult:
	if p.LastName == patientLName:
		PatientN = p
		break;

pat = client.service.GetPatient(PatientN)		
#print pat.Id

facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)

for p in facilities.Facility:
	if p.Name == facility3:
		facility3_id = p.Id
		break;

sec = client.service.GetSections(facility3_id)
#print sec
for  p in sec.Section:
	 if p.Name==SeactionName:
		SectionN = p
		break;

res = client.service.GetAllResourcesOfType(SectionN.Id,'Provider')

for p in res.Resource:
	if p.Name==ProviderResource:
		resprov=p
		break;
#------------------------Policies and Slots------------------------------------------------------		
schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resprov.SchedulingPolicies = schPolicies


RSlots = client.factory.create('ns0:ArrayOfSlot')
RSlot = client.factory.create('ns0:Slot')
RSlot.Time = 'PT16H'
RSlot.Length = 15
RSlot.Capacity = 4
RSlot.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot)
#---
RSlot2 = client.factory.create('ns0:Slot')
RSlot2.Time = 'PT16H15M'
RSlot2.Length = 15
RSlot2.Capacity = 4
RSlot2.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot2)
schPolicy.Slots = RSlots
Result = client.service.UpdateResource(resprov)

#--------------------------------------------------------------------------------
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = resprov.Section
appTimeStamp = datetime.datetime(2013,05,28,19,00,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
#appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
appointment.HighPriorityReschedule='1'

MakeAppt = client.service.CreateAppointment(appointment)

HighPr = MakeAppt.HighPriorityReschedule 
HighId = MakeAppt.Id
DTime = MakeAppt.Time


appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = resprov.Section
appTimeStamp = datetime.datetime(2013,05,28,19,15,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
#appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

MakeAppt1 = client.service.CreateAppointment(appointment)

relation = client.factory.create('ns0:AppointmentRelation')
ARelation = client.factory.create('ns0:ArrayOfAppointmentRelation')
relation.ChildAppointment = MakeAppt1
relation.RelationType='Followup'
ARelation.AppointmentRelation = relation
MakeAppt.ChildAppointments = ARelation

RelResults = client.service.UpdateAppointment(MakeAppt)

print 'Step 1 Search existing individual appointment'+'\n'

ATimeFrom = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day)
ATimeTo = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day+1)

Asso = client.service.GetAppointmentsForPatient(pat.Id,ATimeFrom,ATimeTo)
for p in Asso.Appointment:
	if p.Id==MakeAppt.Id:
		AChild=p
		break;

print 'Step 2 Identify the appointment to reschedule'+'\n'
Apt = client.service.GetAppointment(MakeAppt.Id)
print 'An appointment is:',Apt.Status,'for:',pat.Person.LastName,',',pat.Person.FirstName,'On:',DTime, '\n'

print 'Step 3 Review the associated appointments'+'\n'

rela = client.service.GetAllRelatedAppointments(MakeAppt)
print rela

print 'Step 4 Search for available appointment slot.'+'\n'

#print resprov.SchedulingPolicies.SchedulingPolicy

print 'Step 5 Display the patient pending appointments'+'\n'

PatApt = client.service.GetAppointmentsForPatient(pat.Id,datetime.datetime(2013,05,28),datetime.datetime(2013,05,29))
for p in PatApt.Appointment:
	if p.Status=='Scheduled':
		SApt=p
		break;
print SApt

print 'checkpoint 1'
if logdetail == 1:
	print SApt
print 'verified patinet\'s pending appointments'

print 'Step 6 Display the patient no-show (unkept) appointment history'+'\n'
schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resprov.SchedulingPolicies = schPolicies


RSlots = client.factory.create('ns0:ArrayOfSlot')
RSlot = client.factory.create('ns0:Slot')
RSlot.Time = 'PT19H'
RSlot.Length = 15
RSlot.Capacity = 4
RSlot.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot)
#---
RSlot2 = client.factory.create('ns0:Slot')
RSlot2.Time = 'PT19H15M'
RSlot2.Length = 15
RSlot2.Capacity = 4
RSlot2.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot2)
schPolicy.Slots = RSlots
Result = client.service.UpdateResource(resprov)

appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = resprov.Section
appTimeStamp = datetime.datetime(2013,05,21,22,15,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
#appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

MakeAppt2 = client.service.CreateAppointment(appointment)

PerApt = client.service.NoShowAppointment(MakeAppt2.Id)

NoShow = client.service.GetAppointmentsForPatient(pat.Id,datetime.datetime(2013,05,21),datetime.datetime(2013,05,22))
for p in NoShow.Appointment:
	if p.Activity.AppointmentActivity[1].ActivityType=='NoShow':
		NShow=p
		break;
#print NShow.Activity

print 'Step 7 Select the appointment slot'+'\n'
schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '3'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resprov.SchedulingPolicies = schPolicies


RSlots = client.factory.create('ns0:ArrayOfSlot')
RSlot = client.factory.create('ns0:Slot')
RSlot.Time = 'PT19H'
RSlot.Length = 15
RSlot.Capacity = 4
RSlot.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot)
#---
RSlot2 = client.factory.create('ns0:Slot')
RSlot2.Time = 'PT19H15M'
RSlot2.Length = 15
RSlot2.Capacity = 4
RSlot2.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot2)
schPolicy.Slots = RSlots
#---
RSlot3 = client.factory.create('ns0:Slot')
RSlot3.Time = 'PT19H30M'
RSlot3.Length = 15
RSlot3.Capacity = 4
RSlot3.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot3)
schPolicy.Slots = RSlots
Result = client.service.UpdateResource(resprov)

avail = client.service.GetResourceAvailability(resprov.Id,datetime.datetime(2013,05,29),datetime.datetime(2013,05,30))
#print avail

print 'Step 8 Reassign the patients appointment'+'\n'

appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = resprov.Section
appTimeStamp = datetime.datetime(2013,05,29,22,00,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
appointment.HighPriorityReschedule='1'

MakeAppt3 = client.service.CreateAppointment(appointment)
#print MakeAppt3

print 'checkpoint 2'
if logdetail == 1:
	print MakeAppt3
print 'verified patient\'s reassigned appointment'

HighPr = MakeAppt.HighPriorityReschedule 
HighId = MakeAppt.Id

print 'Step 9 Reschedule the associated appointments'+'\n'

schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '4'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resprov.SchedulingPolicies = schPolicies


RSlots = client.factory.create('ns0:ArrayOfSlot')
RSlot = client.factory.create('ns0:Slot')
RSlot.Time = 'PT19H'
RSlot.Length = 15
RSlot.Capacity = 4
RSlot.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot)
#---
RSlot2 = client.factory.create('ns0:Slot')
RSlot2.Time = 'PT19H15M'
RSlot2.Length = 15
RSlot2.Capacity = 4
RSlot2.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot2)
schPolicy.Slots = RSlots
#---
RSlot3 = client.factory.create('ns0:Slot')
RSlot3.Time = 'PT19H30M'
RSlot3.Length = 15
RSlot3.Capacity = 4
RSlot3.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot3)
schPolicy.Slots = RSlots
Result = client.service.UpdateResource(resprov)
		
		
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = resprov.Section
appTimeStamp = datetime.datetime(2013,05,30,22,00,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

MakeAppt4 = client.service.CreateAppointment(appointment)	

relation = client.factory.create('ns0:AppointmentRelation')
ARelation = client.factory.create('ns0:ArrayOfAppointmentRelation')
relation.ChildAppointment = MakeAppt4
relation.RelationType='Followup'
ARelation.AppointmentRelation = relation
MakeAppt3.ChildAppointments = ARelation

RelResults = client.service.UpdateAppointment(MakeAppt3)	
#print RelResults

print 'Step 10 Send the appointment notification'+'\n'

Que = client.factory.create('ns0:CommunicationQueueItem')

Que.Recipient = pat.Id
Que.SendBy = datetime.datetime(2013,5,25)
Que.SentOn = datetime.datetime(2013,5,24)
Que.Subject = 'Appointment Reschedule'
Que.Body = 'Reschedule appointment'
Que.Appointment = MakeAppt4
QAdd = client.service.AddToCommunicationQueue(Que)
Que1 = client.service.GetAllRelatedCommunications(MakeAppt4)

print 'checkpoint 3'
print 'verified new patient appointment notification letter'
if logdetail == 1:
	print Que1
